%**************************************************************************
% This program is to simulate Direct Torque Control for 3-level 5-Phase
% inverter, single space vectors are used by considering the d3-q3 flux, 
% the rotor speed information 
% is to used to manipulated the  36 and 72  degree vectors
% The vectors the largest redundant vector and the second outmost decagon is used
% as to balance the NP
% Simulate one: the elvaluate the Neutral Balance Technique under Classic DTC
% code is written by liliang Gao in 2009/02/14 at Uni of StrathClyde
%**************************************************************************

%==========================================================================
function [sys,x0,str,ts] = ClassicDTC(t,x,u,flag)
%==========================================================================
switch flag,

    case 0,
    [sys,x0,str,ts]=mdlInitializeSizes;
    
    case 1,
    sys=mdlDerivatives(t,x,u);
    
    case 2,
    sys=mdlUpdate(t,x,u);
    
    case 3,
    sys=mdlOutputs(t,x,u);

    case 4,
    sys=mdlGetTimeOfNextVarHit(t,x,u);

    case 9,
    sys=mdlTerminate(t,x,u);

    otherwise
    error(['Unhandled flag = ',num2str(flag)]);
    end
%==========================================================================
function [sys,x0,str,ts]=mdlInitializeSizes
sizes = simsizes;

sizes.NumContStates  = 0;
sizes.NumDiscStates  = 23;
sizes.NumOutputs     = 21;
sizes.NumInputs      = 12;
sizes.DirFeedthrough = 1;
sizes.NumSampleTimes = 1;   

sys = simsizes(sizes);

x0=[0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0.01;0.01;0;0;0.0001;0.0001];

str = [];

ts=[50e-6 0];          % 10KHz Switching Frequency
%==========================================================================
function sys=mdlDerivatives(t,x,u)

sys = [];
%==========================================================================
function sys=mdlUpdate(t,x,u)
%--------------------------------------------------------------------------  
Kit=0.15;  
Kpt=1.2;            
Kif=1.2;
Kpf=15;
Kp=0.14;
Kispd=0.00625;          
Kpspd=2;    
Kcorspd=0.003125;

Rs=0.668;
Rr=0.52;
Lls=2.9e-3;
Llr=2.9e-3;
Lm=101e-3;
Ls=Lm+Lls;
Lr=Lm+Llr;
Q=1-Lm^2/(Ls*Lr);       % Stator leakage coefficient

Llr3=1.6e-3;
Rr3=0.32;
Lm3=11.1e-3;
Lr3=Llr3+Lm3;
Ls3=Lm3+Lls;

%----------------------parameter for the sliding mode observer-------

J=0.01;
B1=0;
La=Ls-Lm^2/(Lr);
La3=Ls3-Lm3^2/(Lr3);
km1=200;
km2=200;
V=[1, 2; 2, 1];

%--------------------------------------------------------------------
a=2*pi/5;         Ts=50e-6;
sina=sin(a);      sin2a=sin(2*a);
sin3a=sin(3*a);   sin4a=sin(4*a);
cosa=cos(a);      cos2a=cos(2*a);
cos3a=cos(3*a);   cos4a=cos(4*a);

SpeedErrStmax=10.5;
SpeedErrStmin=-10.5;
Torquemax=10.5;
Torquemin=-10.5;
FluxBand=0.005;  % Flux hysteresis band
TorqueBand=0.5;
%--------------------------------------------------------------------------
%     Ia=u(1); Ib=u(2); Ic=u(3); Id=u(4); Ie=u(5);
%     Rposition=u(6); RotorSpeed=u(7);
%     if u(8)==0 Vdc=1e-6; else Vdc=u(8); end
%     FluxRef=u(9); 
%     SpeedRef=u(10); 
%     Torque=u(11);
%     StatorFlux_dse=u(12);
%     StatorFlux_qse=u(13);
%     StatorFlux_d3ss=u(14);
%     StatorFlux_q3ss=u(15);
%     te3=u(16);
%     FluxEnable=u(17);
%     Wr=RotorSpeed;
    
    Ia=u(1); Ib=u(2); Ic=u(3); Id=u(4); Ie=u(5);
    Rposition=u(6); RotorSpeed=u(7);
    if u(8)==0 Vdc=1e-6; else Vdc=u(8); end
    FluxRef=u(9); 
    SpeedRef=u(10); 
    Torque=u(11);
    CapDiff=u(12);
    Wr=RotorSpeed;
%------------------Transformation from abcde to d1-q1 stationary space-----

    Idss=(0.4)*(Ia+cosa*Ib+cos2a*Ic+cos3a*Id+cos4a*Ie);
    Iqss=(0.4)*(   sina*Ib+sin2a*Ic+sin3a*Id+sin4a*Ie);  
    
%------------------Transformation from abcde to d1-q1 stationary space-----

    Id3ss=(0.4)*(Ia+cosa*Ic+cos2a*Ie+cos3a*Ib+cos4a*Id);
    Iq3ss=(0.4)*(   sina*Ic+sin2a*Ie+sin3a*Ib+sin4a*Id);  
    
%-------------------------Speed regulation --------------------------------
    StatorFlux_ds=x(1);       % Calculate stator flux mag and ang
    StatorFlux_qs=x(2);
    SpeedErrSt=x(3);           % Speed regulation
    SpeedCalCnt=x(4);
    TorqueRef=x(5);
    Xk_1=x(16:19);
    Xk_3=x(20:23);
    StatorFluxAng=x(9);
    
    if (SpeedCalCnt==0) 
               
    SpeedErr=SpeedRef-RotorSpeed;
    Upispd=SpeedErrSt+Kpspd*SpeedErr;
    
    TorqueRef=Upispd;          % Integration Correction
    if (Upispd>Torquemax) TorqueRef=Torquemax; end
    if (Upispd<Torquemin) TorqueRef=Torquemin; end
    SpeedErrSt=SpeedErrSt+Kispd*SpeedErr;
    if (SpeedErrSt>Torquemax)SpeedErrSt=Torquemax; end
    if (SpeedErrSt<Torquemin)SpeedErrSt=Torquemin; end 
    end
    SpeedCalCnt=SpeedCalCnt+1;
    if (SpeedCalCnt>=120)
        SpeedCalCnt=0;
    end
    
%----------------------------Stator flux estimation ----------------------- 

  if x(6)==0 RotorFluxMag=1e-6;else RotorFluxMag=x(6);end
    RFluxSlipAng=x(7);
    RotorFluxAng=x(8);%Flux update
    RotorFluxAng=rem((Rposition+RFluxSlipAng), 2*pi);
    
    Idse=Idss*cos(RotorFluxAng)+Iqss*sin(RotorFluxAng);
    Iqse=-Idss*sin(RotorFluxAng)+Iqss*cos(RotorFluxAng);
    
    Tr=Lr/Rr;
    RotorFluxMag=RotorFluxMag+(Lm*Idse-RotorFluxMag)*Ts/Tr;
    RFluxSlipAng=rem((RFluxSlipAng+Lm/RotorFluxMag*Iqse*Ts/Tr), 2*pi);
   
    StatorFlux_ds=Lm*(Xk_1(3)-Lm*Xk_1(1))/Lr+Ls*Xk_1(1);
    StatorFlux_qs=Lm*(Xk_1(4)-Lm*Xk_1(2))/Lr+Ls*Xk_1(2);
    
    StatorFluxMag=sqrt(StatorFlux_ds^2+StatorFlux_qs^2);
    if (StatorFluxMag<=1e-6)
        StatorFluxMag=1e-6;end

     tempf1=StatorFlux_ds/StatorFluxMag;
     tempf2=StatorFlux_qs/StatorFluxMag;
     if (tempf1>=1)  tempf1=1; end
     if (tempf1<=-1) tempf1=-1;end
     StatorFluxAng=acos(tempf1);
     if (StatorFlux_qs<0)
     StatorFluxAng=2*pi-StatorFluxAng;end
 
  %--------------------------------d3-q3 stator flux-----------------------
 
    StatorFlux_ds_3=Lm3*(Xk_3(3)-Lm3*Xk_3(1))/Lr3+Ls3*Xk_3(1);
    StatorFlux_qs_3=Lm3*(Xk_3(4)-Lm3*Xk_3(2))/Lr3+Ls3*Xk_3(2);
    StatorFluxMag_3=sqrt(StatorFlux_ds_3^2+StatorFlux_qs_3^2);
    
    if (StatorFluxMag_3<=1e-6)
        StatorFluxMag_3=1e-6;end

     tempf1=StatorFlux_ds_3/StatorFluxMag_3;
     tempf2=StatorFlux_qs_3/StatorFluxMag_3;
     if (tempf1>=1)  tempf1=1; end
     if (tempf1<=-1) tempf1=-1;end
     StatorFluxAng_3=acos(tempf1);
     if (StatorFlux_qs_3<0)
     StatorFluxAng_3=2*pi-StatorFluxAng_3;end
   
   %--------------------------------------------------------------------------
   
    TorqueErr=x(11);
    FluxErr=x(12);
    SwitchingPos=x(13);
    SectorNum_3=x(14);
    BEMF=x(15);
    
 
   %----------------------d1 q1 space angle calculation--------------------
        
     SectorNum=1;
    if (StatorFluxAng>(19*pi/10))
        SectorNum=1;    
    elseif StatorFluxAng>(17*pi/10)
       SectorNum=10;
    elseif StatorFluxAng>(15*pi/10)
       SectorNum=9 ; 
    elseif StatorFluxAng>(13*pi/10)
       SectorNum=8;
    elseif StatorFluxAng>(11*pi/10)
       SectorNum=7;
    elseif StatorFluxAng>(9*pi/10)
       SectorNum=6;
    elseif StatorFluxAng>(7*pi/10)
       SectorNum=5;
    elseif StatorFluxAng>(5*pi/10)
       SectorNum=4;
    elseif StatorFluxAng>(3*pi/10)
       SectorNum=3;
    elseif StatorFluxAng>(pi/10)
       SectorNum=2; 
    else
       SectorNum=1;
    end

%----------------------d3 q3 space angle calculation--------------------
        
     SectorNum_3=1;
    if (StatorFluxAng_3>(19*pi/10))
        SectorNum_3=1;    
    elseif StatorFluxAng_3>(17*pi/10)
       SectorNum_3=10;
    elseif StatorFluxAng_3>(15*pi/10)
       SectorNum_3=9 ; 
    elseif StatorFluxAng_3>(13*pi/10)
       SectorNum_3=8;
    elseif StatorFluxAng_3>(11*pi/10)
       SectorNum_3=7;
    elseif StatorFluxAng_3>(9*pi/10)
       SectorNum_3=6;
    elseif StatorFluxAng_3>(7*pi/10)
       SectorNum_3=5;
    elseif StatorFluxAng_3>(5*pi/10)
       SectorNum_3=4;
    elseif StatorFluxAng_3>(3*pi/10)
       SectorNum_3=3;
    elseif StatorFluxAng_3>(pi/10)
       SectorNum_3=2; 
    else
       SectorNum_3=1;
    end
%     
%-----------------------------------Torque Estimation----------
    Torque1=x(10);
    Te=2.5*((StatorFlux_ds*Xk_1(2)-StatorFlux_qs*Xk_1(1))+3*(StatorFlux_ds_3*Xk_3(2)-StatorFlux_qs_3*Xk_3(1)));   
    TorqueErr=TorqueRef-Te;    % Torque and flux regulation
    FluxErr=FluxRef-StatorFluxMag;
    
%--------------------------- hysteresis band--------------

  phi=0;
  if (FluxErr+FluxBand<0)  
      phi=0;
  end
  if (FluxErr-FluxBand>0)  
      phi=1;
  end

  Tor=0;
  if (TorqueErr+TorqueBand<0)  
     Tor=-1;
  end
  if (TorqueErr-TorqueBand>0) 
     Tor=1;
  end

  %-----------------------------Back_Emf Calculation-----------------------
    
%   BEMF=RotorSpeed*StatorFluxMag;
%   tempf=0.17082039325*Vdc-28.6;    %6; %28.6;  
%   BemfLevel=-1;
%   if (BEMF>tempf) BemfLevel=1;
%   elseif (BEMF>-tempf) BemfLevel=0;
%   else BemfLevel=-1;
%   end
  
  BemfLevel=-1;
  if (RotorSpeed>314/8) BemfLevel=1;
  elseif (RotorSpeed>-314/8) BemfLevel=0;
  else BemfLevel=-1;
  end
  
%------------------------------Space Vector Selection based on Bemf info----  
 if(BemfLevel==0)     
  if (phi==1)
    if (Tor==0)
        SwitchingPos=10; end 
    if (Tor==1)
        SwitchingPos=1; end 
    if (Tor==-1)
        SwitchingPos=9; end
  end

  if (phi==0)
    if (Tor==0)
        SwitchingPos=10;end
    if (Tor==1)
        SwitchingPos=4; end 
    if (Tor==-1)
        SwitchingPos=6; end    
  end
end

if(BemfLevel==1)  
  if (phi==1)
    if (Tor==0)
        SwitchingPos=10;end 
    if (Tor==1)
        SwitchingPos=2;end 
    if (Tor==-1)
        SwitchingPos=9;end   
  end

  if (phi==0)
    if (Tor==0)
        SwitchingPos=10;end
    if (Tor==1)
        SwitchingPos=3;end   
    if (Tor==-1)
        SwitchingPos=6;end   
   
  end
end
  
 if(BemfLevel==-1)  
  if (phi==1)
    if (Tor==0)
        SwitchingPos=10; end 
    if (Tor==1)
        SwitchingPos=1; end 
    if (Tor==-1)
        SwitchingPos=8;end 
   
  end

  if (phi==0)
    if (Tor==0)
        SwitchingPos=10;end
    if (Tor==1)
        SwitchingPos=4;end   
    if (Tor==-1)
        SwitchingPos=7;end  
  end
 end

 SwitchingPos=SwitchingPos+(SectorNum-1);
 SwitchingPos=mod(SwitchingPos, 10);
    
%----------------------------Using 72 degree vectors-----------------------

%if(BemfLevel==0)     
%   if (phi==1)
%     if (Tor==0)
%         SwitchingPos=10; end 
%     if (Tor==1)
%         SwitchingPos=2; end 
%     if (Tor==-1)
%         SwitchingPos=8; end
%   end
% 
%   if (phi==0)
%     if (Tor==0)
%         SwitchingPos=10;end
%     if (Tor==1)
%         SwitchingPos=3; end 
%     if (Tor==-1)
%         SwitchingPos=7; end    
%   end
% end
% 
%  SwitchingPos=SwitchingPos+(SectorNum-1);
%  SwitchingPos=mod(SwitchingPos, 10);


%--------------------------------------------------------------------------
  
  if (Tor==0)    
  Vd1ss=0; 
  Vq1ss=0; 
  SwitchingPos=10;
  Vd3ss=0;
  Vq3ss=0;
  else
  if (SwitchingPos==0)
      if (SectorNum_3==1||SectorNum_3==2||SectorNum_3==3||SectorNum_3==9||SectorNum_3==10)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
  elseif (SwitchingPos==1)
      if (SectorNum_3==2||SectorNum_3==3||SectorNum_3==4||SectorNum_3==5||SectorNum_3==6)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
 elseif (SwitchingPos==2)
      if (SectorNum_3==5||SectorNum_3==6||SectorNum_3==7||SectorNum_3==8||SectorNum_3==9)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
 elseif (SwitchingPos==3)
      if (SectorNum_3==8||SectorNum_3==9||SectorNum_3==10||SectorNum_3==1||SectorNum_3==2)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
  elseif (SwitchingPos==4)
      if (SectorNum_3==1||SectorNum_3==2||SectorNum_3==3||SectorNum_3==4||SectorNum_3==5)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
   elseif (SwitchingPos==5)
      if (SectorNum_3==4||SectorNum_3==5||SectorNum_3==6||SectorNum_3==7||SectorNum_3==8)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
   elseif (SwitchingPos==6)
      if (SectorNum_3==7||SectorNum_3==8||SectorNum_3==9||SectorNum_3==10||SectorNum_3==1)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
   elseif (SwitchingPos==7)
      if (SectorNum_3==10||SectorNum_3==1||SectorNum_3==2||SectorNum_3==3||SectorNum_3==4)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
   elseif (SwitchingPos==8)
      if (SectorNum_3==3||SectorNum_3==4||SectorNum_3==5||SectorNum_3==6||SectorNum_3==7)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
  elseif (SwitchingPos==9)
      if (SectorNum_3==6||SectorNum_3==7||SectorNum_3==8||SectorNum_3==9||SectorNum_3==10)
          Vd1ss=0.5236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.5236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.0764*Vdc*cos(mod((pi+3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.0764*Vdc*sin(mod((pi+3*SwitchingPos*pi/5),2*pi));
      else
          Vd1ss=0.3236*Vdc*cos((SwitchingPos)*pi/5);
          Vq1ss=0.3236*Vdc*sin((SwitchingPos)*pi/5);
          Vd3ss=0.1236*Vdc*cos(mod((3*SwitchingPos*pi/5),2*pi));
          Vq3ss=0.1236*Vdc*sin(mod((3*SwitchingPos*pi/5),2*pi));
      end
  else
          Vd1ss=0; 
          Vq1ss=0;
          Vd3ss=0;
          Vq3ss=0;
  end
  end
      
      
  
   %-----------------------sliding mode observer for d1-q1 flux--------------
   
   %--------------------gain calculation-------------------------------------
   
   W=[-Rr/Lr,  Wr,   0,   0; 
       -Wr,  -Rr/Lr, 0,   0;
        0,      0, -Rr/Lr, Wr;
        0,      0, -Wr, -Rr/Lr;];
   
    X=[-15, 0, 0, 0; 0, -15, 0, 0; 0, 0, -15, 0; 0, 0, 0, -15];
    
    Y=W-X;
    
    I=[Rr*Lm/(Lr^2*La), -Wr*Lm/(Lr*La); Wr*Lm/(Lr*La), Rr*Lm/(Lr^2*La)]*V;
    J=[I(1,1); I(2,1);I(1,2);I(2,2);];
    K=-inv(Y)*J;
    T=[K(1), K(3);K(2), K(4)];
    L=-(V*inv(T))';
    
    K1=200;       
    K2=200;       
    
    K3=[K1*L(1,1),K2*L(1,2)];
    K4=[K1*L(2,1),K2*L(2,2)];
    
   %------------------------discretizaion--------------------------------
   
   a11=-(Rs/La+Lm^2*Rr/(Lr^2*La));
   a12= Rr*Lm/(Lr^2*La);
   a13=Wr*Lm/(Lr*La);
   a14=Rr*Lm/Lr;
   a15=-Rr/Lr;
   a16=Wr;
   
    A=[a11,    0,   a12,   a13;
        0,    a11, -a13,   a12;
       a14,    0,   a15,  -a16;
        0,    a14,  a16,   a15;];     
  B=[1/La, 0;0, 1/La; 0, 0;0, 0 ];
  I_1= eye(4);
  
  Ad=I_1+A*Ts;
  Bd=B*Ts;
  
  VK=[Vd1ss; Vq1ss];
  Xk_1=Ad*Xk_1+Bd*VK;

  Ia1ss=Xk_1(1); 
  Ib1ss=Xk_1(2);
  
  Flux_a1rs=Xk_1(3);
  Flux_b1rs=Xk_1(4);
  
  %-------------------------current and flux compensation----------------------------------
  
  s1=Idss-Xk_1(1);
  s2=Iqss-Xk_1(2);       
  
  if     (s1>0)  Sign_s1=1;
  elseif (s1<0)  Sign_s1=-1;
  else           Sign_s1=0;
  end

  if     (s2>0)  Sign_s2=1;
  elseif (s2<0)  Sign_s2=-1;
  else           Sign_s2=0;
  end
    
  Xk_1(1)=Xk_1(1)+Ts*K1*Sign_s1;
  Xk_1(2)= Xk_1(2)+Ts*K2* Sign_s2;

  Xk_1(3)=Xk_1(3)+Ts*K3*[Sign_s1;Sign_s2];
  Xk_1(4)= Xk_1(4)+Ts*K4*[Sign_s1;Sign_s2];
  
  
 %-----------------------sliding mode observer for d3-q3 flux--------------
 
 %--------------------gain calculation ------------------------------------
   
   W_3=[-Rr3/Lr3,  3*Wr,   0,   0; 
       -3*Wr,  -Rr3/Lr3, 0,   0;
        0,      0, -Rr3/Lr3, 3*Wr;
        0,      0, -3*Wr, -Rr3/Lr3;];
   
    X_3=[-15, 0, 0, 0; 0, -15, 0, 0; 0, 0, -15, 0; 0, 0, 0, -15];
    
    Y_3=W_3-X_3;
    
    I_3=[Rr3*Lm3/(Lr3^2*La3), -3*Wr*Lm3/(Lr3*La3); 3*Wr*Lm3/(Lr3*La3), Rr3*Lm3/(Lr3^2*La3)]*V;
    J_3=[I_3(1,1); I_3(2,1);I_3(1,2);I_3(2,2);];
    K_3=-inv(Y_3)*J_3;
    T_3=[K_3(1), K_3(3);K_3(2), K_3(4)];
    L_3=-(V*inv(T_3))';
    
    K1=200;       
    K2=200;       
    
    K3=[K1*L_3(1,1),K2*L_3(1,2)];
    K4=[K1*L_3(2,1), K2*L_3(2,2)];
    
   %------------------------discretizaion--------------------------------
   
   a11_3=-(Rs/La3+Lm3^2*Rr3/(Lr3^2*La3));
   a12_3= Rr3*Lm3/(Lr3^2*La3);
   a13_3=3*Wr*Lm3/(Lr3*La3);
   a14_3=Rr3*Lm3/Lr3;
   a15_3=-Rr3/Lr3;
   a16_3=3*Wr;
   
    A_3=[a11_3,    0,   a12_3,   a13_3;
        0,    a11_3, -a13_3,   a12_3;
       a14_3,    0,   a15_3,  -a16_3;
        0,    a14_3,  a16_3,   a15_3;];     
  B_3=[1/La3, 0;0, 1/La3; 0, 0;0, 0 ];
  I_1_3= eye(4);
  
  Ad_3=I_1_3+A_3*Ts;
  Bd_3=B_3*Ts;
  
  VK_3=[Vd3ss; Vq3ss];
  Xk_3=Ad_3*Xk_3+Bd_3*VK_3;

  Ia3ss=Xk_3(1); 
  Ib3ss=Xk_3(2);
  
  Flux_a3rs=Xk_3(3);
  Flux_b3rs=Xk_3(4);
  
  %-------------------------current and flux compensation----------------------------------
  
  s1_3=Id3ss-Xk_3(1);
  s2_3=Iq3ss-Xk_3(2);       
  
  if     (s1_3>0)  Sign_s1_3=1;
  elseif (s1_3<0)  Sign_s1_3=-1;
  else            Sign_s1_3=0;
  end

  if     (s2_3>0)  Sign_s2_3=1;
  elseif (s2_3<0)  Sign_s2_3=-1;
  else            Sign_s2_3=0;
  end
    
  Xk_3(1)=Xk_3(1)+Ts*K1*Sign_s1_3;
  Xk_3(2)=Xk_3(2)+Ts*K2* Sign_s2_3;

  Xk_3(3)=Xk_3(3)+Ts*K3*[Sign_s1_3;Sign_s2_3];
  Xk_3(4)= Xk_3(4)+Ts*K4*[Sign_s1_3;Sign_s2_3];

%--------------------------------------------------------------------------
    sys=[StatorFlux_ds;StatorFlux_qs;SpeedErrSt;SpeedCalCnt;TorqueRef;RotorFluxMag;RFluxSlipAng;RotorFluxAng;StatorFluxAng;Torque1;
         TorqueErr;FluxErr;SwitchingPos; SectorNum_3; BEMF;Xk_1;Xk_3];     
%--------------------------------------------------------------------------
%==========================================================================
function sys=mdlOutputs(t,x,u)
%--------------------------------------------------------------------------
    Ia=u(1);
    Ib=u(2);
    Ic=u(3);
    Id=u(4);
    Ie=u(5);
    CapDiff=u(12);
    
    if CapDiff>1
       Hb=1;
    end
    if (-1<=CapDiff<=1)
       Hb=0;
    end
    if(CapDiff<-1)
        Hb=-1;
    end
    
    Ts=50e-6; 
    t_record=t;
    StatorFlux_ds=x(1);      
    StatorFlux_qs=x(2);
    RotorFluxMag=x(6);
    RFluxSlipAng=x(7);
    RotorFluxAng=x(8);
    StatorFluxAng=x(9);
    SwitchingPos=x(13);
    SectorNum_3=x(14);
    BEMF=x(15);
    We=x(17);
    Xk_1=x(16:19);
    Xk_3=x(20:23);

    Ia1ss=Xk_1(1); 
    Ib1ss=Xk_1(2);
  
    Flux_a1rs=Xk_1(3);
    Flux_b1rs=Xk_1(4);
    
    Ia3ss=Xk_3(1); 
    Ib3ss=Xk_3(2);
  
    Flux_a3rs=Xk_3(3);
    Flux_b3rs=Xk_3(4);
    
    
   
    
  %-----------------------------------vector selection---------------------
  
    if (SwitchingPos==0)
          if (SectorNum_3==1||SectorNum_3==2||SectorNum_3==3||SectorNum_3==9||SectorNum_3==10)  %1  % 21001
           ta1=t_record;  
           ta2=(Ts+Ts)/2+t_record;
           tb1=t_record;
           tb2=(Ts)+t_record;
           tc1=t_record;
           tc2=t_record;
           td1=t_record;
           td2=t_record;
           te1=t_record;
           te2=(Ts)+t_record;
           
           SwitchStateA=1;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
          else
           if ((Ia>=0&&CapDiff>0)||(Ia<0&&CapDiff>0))  %11001
           ta1=t_record;  
           ta2=(Ts+Ts)/2+t_record;
           tb1=t_record;
           tb2=Ts+t_record;
           tc1=t_record;
           tc2=t_record;
           td1=t_record;
           td2=t_record;
           te1=t_record;
           te2=Ts+t_record;
           
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
           else   %22112
           ta1=t_record;  
           ta2=(Ts+Ts)/2+t_record;
           tb1=t_record;
           tb2=Ts+t_record;
           tc1=t_record;
           tc2=Ts+t_record;
           td1=t_record;
           td2=Ts+t_record;
           te1=t_record;
           te2=Ts+t_record;
           SwitchStateA=1;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=1;
           end
               
          end
    elseif (SwitchingPos==1)
      
     if (SectorNum_3==2||SectorNum_3==3||SectorNum_3==4||SectorNum_3==5||SectorNum_3==6)  % 22101
    
            ta1=t_record;
            ta2=(Ts+Ts)/2+t_record;
            tb1=t_record;
            tb2=(Ts+Ts)/2+t_record;
            tc1=t_record;
            tc2=Ts+t_record;
            td1=t_record;
            td2=t_record;
            te1=t_record;
            te2=Ts+t_record;
           SwitchStateA=1;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
     else
           if (((Ia+Ib+Ic+Ie)>=0&&CapDiff>0)||((Ia+Ib+Ic+Ie)<0&&CapDiff>0))  %11000
           ta1=t_record;  
           ta2=(Ts+Ts)/2+t_record;
           tb1=t_record;
           tb2=Ts+t_record;
           tc1=t_record;
           tc2=t_record;
           td1=t_record;
           td2=t_record;
           te1=t_record;
           te2=t_record;
           
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
           else               % 22111
           ta1=t_record;  
           ta2=Ts+t_record;
           tb1=t_record;
           tb2=Ts+t_record;
           tc1=t_record;
           tc2=Ts+t_record;
           td1=t_record;
           td2=Ts+t_record;
           te1=t_record;
           te2=Ts+t_record;
           
           SwitchStateA=1;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
           end
           
     end
            
 
    elseif (SwitchingPos==2)
        if (SectorNum_3==5||SectorNum_3==6||SectorNum_3==7||SectorNum_3==8||SectorNum_3==9)  %3  12100   
           ta1=(Ts+Ts)/2+t_record;
           ta2=(Ts-Ts)+t_record;
           tb1=(Ts-Ts)/2+t_record;
           tb2=(Ts+Ts)/2+t_record;
           tc1=(Ts+Ts)/2+t_record;
           tc2=(Ts-Ts)+t_record;
           td1=t_record;
           td2=t_record;
           te1=t_record;
           te2=t_record;
           SwitchStateA=0;
           SwitchStateB=1;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
        else
           if (((Ib)>=0&&CapDiff>0)||((Ib)<0&&CapDiff>0))  %11100
           ta1=t_record;
           ta2=Ts+t_record;
           tb1=(Ts-Ts)/2+t_record;
           tb2=(Ts+Ts)/2+t_record;
           tc1=t_record;
           tc2=Ts+t_record;
           td1=t_record;
           td2=t_record;
           te1=t_record;
           te2=t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
           else                    % 22211
           ta1=t_record;
           ta2=Ts+t_record;
           tb1=(Ts-Ts)/2+t_record;
           tb2=(Ts+Ts)/2+t_record;
           tc1=t_record;
           tc2=Ts+t_record;
           td1=t_record;
           td2=Ts+t_record;
           te1=t_record;
           te2=Ts+t_record;
           SwitchStateA=1;
           SwitchStateB=1;
           SwitchStateC=1;
           SwitchStateD=0;
           SwitchStateE=0;
        end
        end
    
    elseif (SwitchingPos==3)
        if (SectorNum_3==1||SectorNum_3==2||SectorNum_3==8||SectorNum_3==9||SectorNum_3==10)  %4  12210
           ta1=t_record;
           ta2=Ts+t_record;
           tb1=(Ts-Ts)/2+t_record;
           tb2=(Ts+Ts)/2+t_record;
           tc1=(Ts-Ts)/2+t_record;
           tc2=(Ts+Ts)/2+t_record;
           td1=t_record;
           td2=Ts+t_record;
           te1=t_record;
           te2=t_record;
           SwitchStateA=0;
           SwitchStateB=1;
           SwitchStateC=1;
           SwitchStateD=0;
           SwitchStateE=0;
        else
           if (((Ia+Ib+Ic+Id)>=0&&CapDiff>0)||((Ia+Ib+Ic+Id)<0&&CapDiff>0))  %01100
           ta1=t_record;
           ta2=t_record;
           tb1=(Ts-Ts)/2+t_record;
           tb2=(Ts+Ts)/2+t_record;
           tc1=(Ts-Ts)/2+t_record;
           tc2=(Ts+Ts)/2+t_record;
           td1=t_record;
           td2=t_record;
           te1=t_record;
           te2=t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
           end                    %12211
           ta1=Ts+t_record;
           ta2=t_record;
           tb1=(Ts-Ts)/2+t_record;
           tb2=(Ts+Ts)/2+t_record;
           tc1=(Ts-Ts)/2+t_record;
           tc2=(Ts+Ts)/2+t_record;
           td1=Ts+t_record;
           td2=t_record;
           te1=t_record;
           te2=Ts+t_record;
           SwitchStateA=0;
           SwitchStateB=1;
           SwitchStateC=1;
           SwitchStateD=0;
           SwitchStateE=0;
        end
    
    elseif (SwitchingPos==4)
        if (SectorNum_3==1||SectorNum_3==2||SectorNum_3==3||SectorNum_3==4||SectorNum_3==5)%5  01210
            ta1=t_record;
            ta2=t_record;
            tb1=Ts+t_record;
            tb2=t_record;
            tc1=t_record;
            tc2=Ts+t_record;
            td1=Ts+t_record;
            td2=t_record;
            te1=t_record;
            te2=t_record; 
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=1;
           SwitchStateD=0;
           SwitchStateE=0;
        else
            if (((Ic)>=0&&CapDiff>0)||((Ic)<0&&CapDiff>0))  %01110
            ta1=t_record;
            ta2=t_record;
            tb1=t_record;
            tb2=Ts+t_record;
            tc1=t_record;
            tc2=Ts+t_record;
            td1=t_record;
            td2=Ts+t_record;
            te1=t_record;
            te2=t_record;
            SwitchStateA=0;
            SwitchStateB=0;
            SwitchStateC=0;
            SwitchStateD=0;
            SwitchStateE=0;
            else      % 12221
            ta1=t_record;
            ta2=Ts+t_record;
            tb1=t_record;
            tb2=Ts+t_record;
            tc1=t_record;
            tc2=Ts+t_record;
            td1=t_record;
            td2=Ts+t_record;
            te1=t_record;
            te2=Ts+t_record;
           SwitchStateA=0;
           SwitchStateB=1;
           SwitchStateC=1;
           SwitchStateD=1;
           SwitchStateE=0;
        end
      end
        
   
     elseif (SwitchingPos==5)
         if (SectorNum_3==4||SectorNum_3==5||SectorNum_3==6||SectorNum_3==7||SectorNum_3==8)%6 01221
           ta1=t_record;
           ta2=t_record;
           tb1=t_record;
           tb2=Ts+t_record;
           tc1=(Ts-Ts)/2+t_record;
           tc2=(Ts+Ts)/2+t_record;
           td1=(Ts-Ts)/2+t_record;
           td2=(Ts+Ts)/2+t_record;
           te1=t_record;
           te2=Ts+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=1;
           SwitchStateD=1;
           SwitchStateE=0;
         else
           if (((Id+Ib+Ic+Ie)>=0&&CapDiff>0)||((Id+Ib+Ic+Ie)<0&&CapDiff>0))  %00110
           ta1=t_record;
           ta2=t_record;
           tb1=t_record;
           tb2=t_record;
           tc1=(Ts-Ts)/2+t_record;
           tc2=(Ts+Ts)/2+t_record;
           td1=(Ts-Ts)/2+t_record;
           td2=(Ts+Ts)/2+t_record;
           te1=t_record;
           te2=t_record;
         
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
           else                      %11221
           ta1=t_record;
           ta2=Ts+t_record;
           tb1=Ts+t_record;
           tb2=t_record;
           tc1=(Ts-Ts)/2+t_record;
           tc2=(Ts+Ts)/2+t_record;
           td1=(Ts-Ts)/2+t_record;
           td2=(Ts+Ts)/2+t_record;
           te1=Ts+t_record;
           te2=t_record;
         
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=1;
           SwitchStateD=1;
           SwitchStateE=0;
         end
         end
           
    
    elseif (SwitchingPos==6)
         if (SectorNum_3==1||SectorNum_3==7||SectorNum_3==8||SectorNum_3==9||SectorNum_3==10)%7  00121
            ta1=t_record;
            ta2=t_record;
            tb1=t_record;
            tb2=t_record;
            tc1=(Ts-Ts)+t_record;
            tc2=(Ts)+t_record;
            td1=(Ts-Ts)+t_record;
            td2=(Ts+Ts)/2+t_record;
            te1=(Ts)+t_record;
            te2=(Ts-Ts)+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=1;
           SwitchStateE=0;
         else
             if (((Id)>=0&&CapDiff>0)||((Id)<0&&CapDiff>0))  %00111
            ta1=t_record;
            ta2=t_record;
            tb1=t_record;
            tb2=t_record;
            tc1=t_record;
            tc2=Ts+t_record;
            td1=t_record;
            td2=Ts+t_record;
            te1=t_record;
            te2=Ts+t_record;
            SwitchStateA=0;
            SwitchStateB=0;
            SwitchStateC=0;
            SwitchStateD=0;
            SwitchStateE=0;
             else  %11222
            ta1=t_record;
            ta2=Ts+t_record;
            tb1=t_record;
            tb2=Ts+t_record;
            tc1=t_record;
            tc2=Ts+t_record;
            td1=t_record;
            td2=Ts+t_record;
            te1=t_record;
            te2=Ts+t_record;
            SwitchStateA=0;
            SwitchStateB=0;
            SwitchStateC=1;
            SwitchStateD=1;
            SwitchStateE=1;
            end      
         end
  
    elseif (SwitchingPos==7)
        if (SectorNum_3==1||SectorNum_3==2||SectorNum_3==3||SectorNum_3==4||SectorNum_3==10)%8  10122
           ta1=t_record;
           ta2=Ts+t_record;
           tb1=t_record;
           tb2=t_record;
           tc1=t_record;
           tc2=Ts+t_record;
           td1=(Ts-Ts)/2+t_record;
           td2=(Ts+Ts)/2+t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=1;
           SwitchStateE=1;
        else
           if (((Ia+Id+Ic+Ie)>=0&&CapDiff>0)||((Ia+Id+Ic+Ie)<0&&CapDiff>0))  %00011
           ta1=t_record;
           ta2=t_record;
           tb1=t_record;
           tb2=t_record;
           tc1=t_record;
           tc2=t_record;
           td1=(Ts-Ts)/2+t_record;
           td2=(Ts+Ts)/2+t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
           else                                %11122
           ta1=Ts+t_record;
           ta2=t_record;
           tb1=t_record;
           tb2=Ts+t_record;
           tc1=Ts+t_record;
           tc2=t_record;
           td1=(Ts-Ts)/2+t_record;
           td2=(Ts+Ts)/2+t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=1;
           SwitchStateE=1;
        end
           end
        
    
    elseif (SwitchingPos==8)
        if (SectorNum_3==3||SectorNum_3==4||SectorNum_3==5||SectorNum_3==6||SectorNum_3==7)%9  10012
        
           ta1=Ts+t_record;
           ta2=t_record;
           tb1=t_record;
           tb2=t_record;
           tc1=t_record;
           tc2=t_record;
           td1=Ts+t_record;
           td2=t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=1;
        else
           if (((Ie)>=0&&CapDiff>0)||((Ie)<0&&CapDiff>0))   % 10011
           ta1=t_record;
           ta2=Ts+t_record;
           tb1=t_record;
           tb2=t_record;
           tc1=t_record;
           tc2=t_record;
           td1=t_record;
           td2=Ts+t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
           else                           % 21122
           ta1=t_record;
           ta2=Ts+t_record;
           tb1=t_record;
           tb2=Ts+t_record;
           tc1=t_record;
           tc2=Ts+t_record;
           td1=t_record;
           td2=Ts+t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=1;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=1;
           SwitchStateE=1;
           end
               
        end
   
    elseif (SwitchingPos==9)
         if (SectorNum_3==6||SectorNum_3==7||SectorNum_3==8||SectorNum_3==9||SectorNum_3==10)%10  21012
           ta1=(Ts-Ts)/2+t_record;
           ta2=(Ts+Ts)/2+t_record;
           tb1=t_record;
           tb2=Ts+t_record;
           tc1=t_record;
           tc2=t_record;
           td1=t_record;
           td2=Ts+t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=1;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=1;
         else
            if (((Ia+Id+Ib+Ie)>=0&&CapDiff>0)||((Ia+Id+Ib+Ie)<0&&CapDiff>0))  %10001
           ta1=(Ts-Ts)/2+t_record;
           ta2=(Ts+Ts)/2+t_record;
           tb1=t_record;
           tb2=t_record;
           tc1=t_record;
           tc2=t_record;
           td1=t_record;
           td2=t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
            else   % 21112
           ta1=(Ts-Ts)/2+t_record;
           ta2=(Ts+Ts)/2+t_record;
           tb1=Ts+t_record;
           tb2=t_record;
           tc1=t_record;
           tc2=Ts+t_record;
           td1=Ts+t_record;
           td2=t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=1;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=1;
         end
         end
         
    elseif (SwitchingPos==10)
           ta1=(Ts-Ts)/2+t_record;
           ta2=(Ts+Ts)/2+t_record;
           tb1=(Ts-Ts)/2+t_record;
           tb2=(Ts+Ts)/2+t_record;
           tc1=(Ts-Ts)/2+t_record;
           tc2=(Ts+Ts)/2+t_record;
           td1=(Ts-Ts)/2+t_record;
           td2=(Ts+Ts)/2+t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
    
    else
           ta1=(Ts-Ts)/2+t_record;
           ta2=(Ts+Ts)/2+t_record;
           tb1=(Ts-Ts)/2+t_record;
           tb2=(Ts+Ts)/2+t_record;
           tc1=(Ts-Ts)/2+t_record;
           tc2=(Ts+Ts)/2+t_record;
           td1=(Ts-Ts)/2+t_record;
           td2=(Ts+Ts)/2+t_record;
           te1=(Ts-Ts)/2+t_record;
           te2=(Ts+Ts)/2+t_record;
           SwitchStateA=0;
           SwitchStateB=0;
           SwitchStateC=0;
           SwitchStateD=0;
           SwitchStateE=0;
 
         end
    
        
%%--------------------------------------------------------------------------   
    sys=[ta1;ta2;tb1;tb2;tc1;tc2;td1;td2;te1;te2;
         SwitchStateA;SwitchStateB;SwitchStateC;SwitchStateD;SwitchStateE;SwitchingPos;We;Ia1ss;Ib1ss;Flux_a1rs;Flux_b1rs];
%==========================================================================
function sys=mdlGetTimeOfNextVarHit(t,x,u);

sys =[];
%==========================================================================
function sys=mdlTerminate(t,x,u)

sys = [];
%==========================================================================